Some HTTP C2 profiles add a cookie in the request to carry information such as metadata, or even just as a canary.  We can use the `%{HTTP_COOKIE}` variable to only redirect the request if this cookie is present.

RewriteEngine on

RewriteCond %{HTTP_COOKIE} TestCookie [NC]
RewriteRule .* https://localhost:8443/cookie-test [P]

  

If we curl localhost without the cookie, we just see the default index page.

ubuntu@redirector-1 ~> curl -k https://localhost
Hello from Apache

  

But if we add the cookie, Apache proxies the request to the Team Server.

ubuntu@redirector-1 ~> curl -k --cookie "TestCookie=Blah" https://localhost 

05/26 15:59:08 visit (port 443) from: 127.0.0.1
	Request: GET /cookie-test
	Response: 404 Not Found
	curl/7.68.0

  

Since the rules are processed top-to-bottom, we can layer them to achieve a greater overall effect.  For instance, put specific blocking rules at the top and the proxying rules underneath.

RewriteEngine on

RewriteCond %{HTTP_USER_AGENT} "curl|wget" [NC]
RewriteRule .* - [F]

RewriteCond %{HTTP_COOKIE} "TestCookie" [NC]
RewriteRule .* https://localhost:8443/cookie-test [P]

  

In this case, the user agent rule triggers first so that even if we have the correct cookie name, the default curl/wget strings are blocked.

ubuntu@redirector-1 ~> curl -k --cookie "TestCookie=Blah" https://localhost
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>403 Forbidden</title>
</head><body>
<h1>Forbidden</h1>
<p>You don't have permission to access this resource.</p>
<hr>
<address>Apache/2.4.41 (Ubuntu) Server at localhost Port 443</address>
</body></html>

  

Adding an "allowed" user agent let's it through.

ubuntu@redirector-1 ~> curl -k -A "mozilla" --cookie "TestCookie=Blah" https://localhost

